/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.man.configuration;

import net.minecraftforge.common.ForgeConfigSpec;

public class ManconfigConfiguration {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_SPAWNING;
    public static final ForgeConfigSpec.ConfigValue<Double> MIN_SPAWN_RATE;
    public static final ForgeConfigSpec.ConfigValue<Double> MAX_SPAWN_RATE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> JUMPSCARE;
    public static final ForgeConfigSpec.ConfigValue<Double> MIN_CHASE_DURATION;
    public static final ForgeConfigSpec.ConfigValue<Double> MAX_CHASE_DURATION;
    public static final ForgeConfigSpec.ConfigValue<Boolean> CLIMBING;
    public static final ForgeConfigSpec.ConfigValue<Double> VANISH_DISTANCE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SPAWN_AT_DAY;
    public static final ForgeConfigSpec.ConfigValue<Boolean> DARKNESS_EFFECT;
    public static final ForgeConfigSpec.ConfigValue<Double> DARKNESS_EFFECT_DURATION;
    public static final ForgeConfigSpec.ConfigValue<Boolean> BREAK_BLOCKS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> LIGHTNINGS;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SPAWN_SOUNDS;
    public static final ForgeConfigSpec.ConfigValue<Double> STAGE1_SPAWN_RATE;
    public static final ForgeConfigSpec.ConfigValue<Double> STAGE2_SPAWN_RATE;
    public static final ForgeConfigSpec.ConfigValue<Boolean> OLD_STALK_MECHANIC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> LEGACY_MAN;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SEARCH_MECHANIC;
    public static final ForgeConfigSpec.ConfigValue<Double> BLOCK_HARDNESS;
    public static final ForgeConfigSpec.ConfigValue<Double> BLOCK_HARDNESS_SEARCH;
    public static final ForgeConfigSpec.ConfigValue<Double> BLOCK_BREAK_TIMER;

    static {
        BUILDER.push("Server and Client");
        ENABLE_SPAWNING = BUILDER.comment("enable spawning of the man").define("enable_spawning", true);
        MIN_SPAWN_RATE = BUILDER.comment("minimum duration of spawning in ticks").define("min_spawn_rate", (Object)5000.0);
        MAX_SPAWN_RATE = BUILDER.comment("maximum duration of spawning in ticks").define("max_spawn_rate", (Object)20000.0);
        JUMPSCARE = BUILDER.comment("if true, it shows a jumpscare image when killed").define("jumpscare", true);
        MIN_CHASE_DURATION = BUILDER.comment("minimum duration of getting chased in ticks").define("min_chase_duration", (Object)400.0);
        MAX_CHASE_DURATION = BUILDER.comment("maximum duration of getting chased in ticks").define("max_chase_duration", (Object)1000.0);
        CLIMBING = BUILDER.comment("if true, it can climb vertical blocks").define("climbing", true);
        VANISH_DISTANCE = BUILDER.comment("minimum radius in blocks before it despawns").define("vanish_distance", (Object)30.0);
        SPAWN_AT_DAY = BUILDER.comment("if true, it can also spawn during the day").define("spawn_at_day", true);
        DARKNESS_EFFECT = BUILDER.comment("if true, the player gets the darkness effect when starts getting chased").define("darkness_effect", true);
        DARKNESS_EFFECT_DURATION = BUILDER.comment("the duration in ticks of the darkness effect").define("darkness_effect_duration", (Object)150.0);
        BREAK_BLOCKS = BUILDER.comment("if true, it can break doors and glass/glass panes while it chases the player").define("break_blocks", true);
        LIGHTNINGS = BUILDER.comment("if true, it will summon fake lightnings when despawning or spawning").define("lightnings", true);
        SPAWN_SOUNDS = BUILDER.comment("if true, it will play one of five spawn sounds when spawning or getting closer").define("spawn_sounds", true);
        STAGE1_SPAWN_RATE = BUILDER.comment("the duration in ticks until it will get closer when not looked at").define("stage1_spawn_rate", (Object)600.0);
        STAGE2_SPAWN_RATE = BUILDER.comment("the duration in ticks until it will start chasing the player when not looked at").define("stage2_spawn_rate", (Object)900.0);
        OLD_STALK_MECHANIC = BUILDER.comment("if true, the man will use the old chase mechanic").define("old_stalk_mechanic", false);
        LEGACY_MAN = BUILDER.comment("the structures as well as the dimension will be disabled and the man spawns normally in your world. Create a new world when disabled").define("legacy_man", false);
        SEARCH_MECHANIC = BUILDER.comment("the man will search the nearest player on lost sight and when close enough, destroy neccessary blocks to get the player").define("search_mechanic", true);
        BLOCK_HARDNESS = BUILDER.comment("The max hardness of a block which the man will be able to break, set to -1.0 to disable").define("block_hardness", (Object)2.0);
        BLOCK_HARDNESS_SEARCH = BUILDER.comment("The max hardness of a block which the man will be able to break when searching for the player").define("block_hardness_search", (Object)5.0);
        BLOCK_BREAK_TIMER = BUILDER.comment("The time in ticks for how long the man needs to break a block (higher value = lower speed)").define("block_break_timer", (Object)10.0);
        BUILDER.pop();
        BUILDER.push("Client only");
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

